# Deployment Guide - Odds Predictor

## Pre-Deployment Checklist

### Security
- [ ] Change admin password in `/admin/index.php`
- [ ] Update database credentials in `/includes/config.php`
- [ ] Set proper file permissions (644 files, 755 directories)
- [ ] Enable HTTPS/SSL certificate
- [ ] Create `.htaccess` for admin protection
- [ ] Remove or rename `database.sql` from web root
- [ ] Disable directory listing in `.htaccess`

### Configuration
- [ ] Set Google Analytics ID in `/includes/config.php`
- [ ] Configure database connection
- [ ] Set app URL in `/includes/config.php`
- [ ] Create logs directory with proper permissions
- [ ] Create uploads directory with proper permissions

### Database
- [ ] Create MySQL database
- [ ] Create database user with full privileges
- [ ] Import `database.sql` schema
- [ ] Verify tables created successfully
- [ ] Check default leagues inserted

### Testing
- [ ] Test age verification popup
- [ ] Test admin login
- [ ] Test CSV import with sample data
- [ ] Test prediction generation
- [ ] Test ad display
- [ ] Check Google Analytics tracking
- [ ] Verify all links work
- [ ] Test on mobile devices

---

## Step-by-Step Deployment

### 1. Prepare cPanel Hosting

```bash
# SSH into your server (if available)
ssh username@yourdomain.com

# Create project directory
mkdir -p public_html/odds-predictor
cd public_html/odds-predictor
```

### 2. Upload Files

**Via FTP:**
1. Connect with FTP client
2. Navigate to `/public_html/`
3. Create `odds-predictor` folder
4. Upload all files maintaining structure

**Via cPanel File Manager:**
1. Log into cPanel
2. Go to File Manager
3. Navigate to public_html
4. Create `odds-predictor` folder
5. Upload files via "Upload" button

### 3. Create Database

**Via cPanel:**
1. Go to MySQL Databases
2. Create database: `yourusername_odds`
3. Create user: `yourusername_odds_user`
4. Set password (strong, random)
5. Add user to database with ALL privileges

**Via Command Line:**
```bash
mysql -u root -p
CREATE DATABASE yourusername_odds;
CREATE USER 'yourusername_odds_user'@'localhost' IDENTIFIED BY 'strong_password_here';
GRANT ALL PRIVILEGES ON yourusername_odds.* TO 'yourusername_odds_user'@'localhost';
FLUSH PRIVILEGES;
```

### 4. Import Database Schema

**Via phpMyAdmin:**
1. Go to cPanel → phpMyAdmin
2. Select your database
3. Click "Import" tab
4. Choose `/includes/database.sql`
5. Click "Go"

**Via Command Line:**
```bash
mysql -u yourusername_odds_user -p yourusername_odds < includes/database.sql
```

### 5. Configure Application

Edit `/includes/config.php`:

```php
// Database
define('DB_HOST', 'localhost');
define('DB_USER', 'yourusername_odds_user');
define('DB_PASS', 'your_strong_password');
define('DB_NAME', 'yourusername_odds');

// Application
define('APP_URL', 'https://yourdomain.com/odds-predictor');
define('ADMIN_URL', 'https://yourdomain.com/odds-predictor/admin');

// Google Analytics
define('GA_TRACKING_ID', 'G-YOUR_GA_ID_HERE');
```

### 6. Set File Permissions

**Via SSH:**
```bash
cd /home/username/public_html/odds-predictor

# Set directory permissions
find . -type d -exec chmod 755 {} \;

# Set file permissions
find . -type f -exec chmod 644 {} \;

# Make logs and uploads writable
chmod 755 logs/
chmod 755 uploads/
```

**Via cPanel File Manager:**
1. Right-click directory
2. Select "Change Permissions"
3. Set to 755 for directories, 644 for files

### 7. Create Security Files

Create `/admin/.htaccess`:
```apache
# Disable directory listing
Options -Indexes

# Require HTTPS
RewriteEngine On
RewriteCond %{HTTPS} off
RewriteRule ^(.*)$ https://%{HTTP_HOST}%{REQUEST_URI} [L,R=301]
```

Create `/public_html/odds-predictor/.htaccess`:
```apache
# Disable directory listing
Options -Indexes

# Require HTTPS
RewriteEngine On
RewriteCond %{HTTPS} off
RewriteRule ^(.*)$ https://%{HTTP_HOST}%{REQUEST_URI} [L,R=301]

# Prevent access to sensitive files
<FilesMatch "\.(sql|md|json|env)$">
    Deny from all
</FilesMatch>
```

### 8. Set Admin Password

Edit `/admin/index.php`:

```php
// Generate a strong password hash
$admin_password = 'your_new_secure_password_here';

// Or use PHP's password_hash for better security
// $admin_password_hash = password_hash('your_password', PASSWORD_BCRYPT);
// Then update login check to use password_verify()
```

### 9. Enable HTTPS

**Via cPanel AutoSSL:**
1. Go to cPanel → AutoSSL
2. Click "Check for new certificates"
3. Wait for certificate installation

**Via Let's Encrypt:**
1. Go to cPanel → AutoSSL
2. Or use SSH: `certbot certonly -d yourdomain.com`

### 10. Test Installation

1. Visit: `https://yourdomain.com/odds-predictor/public/`
2. Verify age verification popup
3. Visit: `https://yourdomain.com/odds-predictor/admin/`
4. Login with admin password
5. Check database connection

---

## Initial Data Setup

### Download Sample Data

1. Visit: https://www.football-data.co.uk/downloadm.php
2. Download CSV for 2024/25 season
3. Save locally

### Import Data

1. Go to Admin Panel
2. Select "CSV Import" tab
3. Choose league (e.g., Premier League)
4. Enter season (e.g., 2024/25)
5. Upload CSV file
6. Monitor import progress

### Verify Data

1. Go to main app
2. Select league
3. Verify teams appear
4. Test prediction with sample odds

---

## Post-Deployment

### Monitor Performance

1. **Check Error Logs:**
   ```bash
   tail -f logs/error.log
   tail -f logs/activity.log
   ```

2. **Monitor Database:**
   - Check table sizes
   - Monitor query performance
   - Backup regularly

3. **Check Analytics:**
   - Verify GA tracking
   - Monitor user behavior
   - Track predictions made

### Regular Maintenance

- **Weekly:** Update match data
- **Monthly:** Review error logs, backup database
- **Quarterly:** Update dependencies, security patches
- **Annually:** Review and optimize code

### Backup Strategy

**Backup Database:**
```bash
# Via command line
mysqldump -u yourusername_odds_user -p yourusername_odds > backup_$(date +%Y%m%d).sql

# Via cPanel: Backup Wizard
```

**Backup Files:**
```bash
# Via command line
tar -czf odds-predictor_$(date +%Y%m%d).tar.gz /home/username/public_html/odds-predictor/

# Via cPanel: File Manager
```

---

## Troubleshooting Deployment

### Database Connection Error

**Error:** "Connection failed: Connection refused"

**Solution:**
1. Verify database credentials in config.php
2. Check database exists: `mysql -u user -p -e "SHOW DATABASES;"`
3. Verify user has privileges: `SHOW GRANTS FOR 'user'@'localhost';`
4. Restart MySQL: `service mysql restart`

### Permission Denied Errors

**Error:** "Permission denied" when accessing files

**Solution:**
```bash
# Fix permissions
chmod 755 logs/ uploads/
chmod 644 *.php *.css *.js
```

### CSV Import Fails

**Error:** "Invalid date format" or "Duplicate entry"

**Solution:**
1. Verify CSV format matches template
2. Check file encoding (UTF-8)
3. Review error log in admin panel
4. Try importing smaller file first

### Age Verification Not Working

**Error:** Popup doesn't appear or verification fails

**Solution:**
1. Clear browser cookies
2. Check session configuration in config.php
3. Verify JavaScript enabled in browser
4. Check browser console for errors

### Admin Login Not Working

**Error:** "Invalid password" always appears

**Solution:**
1. Verify password in `/admin/index.php`
2. Check session configuration
3. Try different browser/incognito mode
4. Check server logs for errors

---

## Performance Optimization

### Database Optimization

```sql
-- Add indexes for faster queries
ALTER TABLE matches ADD INDEX idx_season (season);
ALTER TABLE matches ADD INDEX idx_teams (home_team_id, away_team_id);
ALTER TABLE team_stats ADD INDEX idx_team_season (team_id, season);

-- Optimize tables
OPTIMIZE TABLE matches;
OPTIMIZE TABLE teams;
OPTIMIZE TABLE team_stats;
```

### Caching

Add to `/includes/config.php`:
```php
// Enable output buffering
ob_start();

// Set cache headers
header('Cache-Control: public, max-age=3600');
header('Pragma: cache');
```

### Compression

Add to `.htaccess`:
```apache
# Enable gzip compression
<IfModule mod_deflate.c>
    AddOutputFilterByType DEFLATE text/html text/plain text/xml text/css text/javascript application/javascript
</IfModule>
```

---

## Security Hardening

### Additional Security Measures

1. **Disable PHP Execution in Uploads:**
   ```apache
   <FilesMatch "\.php$">
       Deny from all
   </FilesMatch>
   ```

2. **Limit Upload File Size:**
   Edit `php.ini`:
   ```
   upload_max_filesize = 10M
   post_max_size = 10M
   ```

3. **Enable Security Headers:**
   Add to `.htaccess`:
   ```apache
   Header set X-Content-Type-Options "nosniff"
   Header set X-Frame-Options "SAMEORIGIN"
   Header set X-XSS-Protection "1; mode=block"
   ```

4. **Regular Updates:**
   - Keep PHP updated
   - Update MySQL
   - Monitor security advisories

---

## Going Live Checklist

- [ ] Database configured and tested
- [ ] Admin password changed
- [ ] HTTPS/SSL enabled
- [ ] File permissions set correctly
- [ ] Initial data imported
- [ ] Age verification working
- [ ] Admin panel accessible
- [ ] Predictions generating correctly
- [ ] Analytics tracking
- [ ] Error logs monitored
- [ ] Backup strategy in place
- [ ] Security headers configured
- [ ] Database optimized
- [ ] Performance tested
- [ ] Mobile responsiveness verified

---

## Support Resources

- **cPanel Documentation:** https://documentation.cpanel.net/
- **PHP Documentation:** https://www.php.net/docs.php
- **MySQL Documentation:** https://dev.mysql.com/doc/
- **Football Data:** https://www.football-data.co.uk/
- **Responsible Gambling:** https://www.gambleaware.co.uk/

---

**Deployment Date:** _______________
**Deployed By:** _______________
**Notes:** _______________________________________________

