# Odds Predictor - Advanced Odds Prediction Tool

A comprehensive web application for predicting football match odds using multiple statistical models. Built for cPanel hosting with support for historical data import, flexible ad integration, and responsible gambling features.

## Features

### Core Functionality
- **Multiple Prediction Models:**
  - Poisson Distribution Analysis
  - Win Percentage Analysis
  - Expected Goals (xG) Analysis
  - Recent Form Analysis

- **User-Friendly Interface:**
  - Team and league selection
  - Real-time odds input
  - Comprehensive prediction display
  - Model comparison view

- **Data Management:**
  - CSV import system for bulk data uploads
  - Support for football-data.co.uk format
  - Automatic team and statistics aggregation
  - Head-to-head record tracking

### Admin Features
- **CSV Import Panel:**
  - Upload historical match data
  - Automatic data validation
  - Error logging and reporting
  - Upload history tracking

- **Ad Management:**
  - Custom ad slots (your own ads)
  - Network ad integration (PropellerAds, Adsterra, etc.)
  - Enable/disable toggles
  - Multiple ad positions

- **Data Configuration:**
  - Data freshness monitoring
  - Recommended data range display
  - Automatic staleness warnings

### Compliance & Responsibility
- **Age Verification:** Popup requiring 18+ confirmation
- **Legal Disclaimers:** Multiple disclaimer locations
- **Responsible Gambling:** Links to GambleAware and NCPG
- **Google Analytics:** Built-in tracking integration
- **No Liability:** Clear statements throughout app

## System Requirements

- **PHP:** 7.4 or higher
- **MySQL:** 5.7 or higher
- **Web Server:** Apache with mod_rewrite (or Nginx)
- **cPanel Hosting:** Standard shared hosting

## Installation

### Step 1: Upload Files to cPanel

1. Connect via FTP or File Manager
2. Create directory: `/public_html/odds-predictor/`
3. Upload all files maintaining directory structure

### Step 2: Create Database

1. Go to cPanel → MySQL Databases
2. Create new database (e.g., `odds_predictor`)
3. Create new user with full privileges
4. Note the credentials

### Step 3: Configure Database Connection

Edit `/includes/config.php`:

```php
define('DB_HOST', 'localhost');
define('DB_USER', 'your_db_user');
define('DB_PASS', 'your_db_password');
define('DB_NAME', 'odds_predictor');
```

### Step 4: Initialize Database

1. Go to cPanel → phpMyAdmin
2. Select your database
3. Go to "Import" tab
4. Upload `/includes/database.sql`
5. Click "Go"

### Step 5: Configure Google Analytics

Edit `/includes/config.php`:

```php
define('GA_TRACKING_ID', 'G-XXXXXXXXXX'); // Your GA ID
```

### Step 6: Set Admin Password

Edit `/admin/index.php`:

```php
$admin_password = 'your_secure_password'; // Change this!
```

### Step 7: Test Installation

1. Visit: `http://yourdomain.com/odds-predictor/public/`
2. Verify age verification popup appears
3. Check admin panel: `http://yourdomain.com/odds-predictor/admin/`

## Initial Data Setup

### Option 1: Download from football-data.co.uk

1. Visit: https://www.football-data.co.uk/downloadm.php
2. Download CSV files for desired seasons (2022/23, 2023/24, 2024/25)
3. Go to Admin Panel → CSV Import
4. Upload files one by one

### Option 2: Use Provided Template

1. Get template: `/data/CSV_TEMPLATE.md`
2. Prepare your data in CSV format
3. Upload via Admin Panel

## CSV Data Format

Required columns:
```
Date,HomeTeam,AwayTeam,FTHG,FTAG,FTR,HS,AS,HST,AST,HF,AF,HC,AC,B365H,B365D,B365A
```

Example:
```csv
26/12/2024,Arsenal,Chelsea,2,1,H,15,8,6,3,12,14,5,2,1.92,3.30,4.60
```

See `/data/CSV_TEMPLATE.md` for complete documentation.

## Admin Panel

### Access
- URL: `http://yourdomain.com/odds-predictor/admin/`
- Password: Set in `/admin/index.php`

### CSV Import
1. Select league and season
2. Upload CSV file
3. Monitor import progress
4. Review upload history

### Ad Management
- **Custom Ads:** Add your own HTML/JavaScript ads
- **Network Ads:** Integrate PropellerAds, Adsterra, etc.
- **Positions:** Top, middle, bottom of page
- **Enable/Disable:** Toggle ads on/off

### Data Configuration
- View current data range
- Check last update date
- Monitor data freshness

## Prediction Models

### 1. Poisson Distribution
Uses historical goals scored/conceded to calculate match outcome probabilities using Poisson distribution.

**Advantages:**
- Mathematically rigorous
- Accounts for home advantage
- Good for predicting exact scores

### 2. Win Percentage Analysis
Based on historical win rates and head-to-head records.

**Advantages:**
- Simple and intuitive
- Incorporates H2H history
- Easy to understand

### 3. Expected Goals (xG)
Analyzes shot quality and quantity to predict outcomes.

**Advantages:**
- Modern statistical approach
- Accounts for shot quality
- Better than just goal counting

### 4. Recent Form Analysis
Focuses on last 5-10 matches performance.

**Advantages:**
- Captures current momentum
- Reflects recent changes
- Good for active seasons

## Recommended Bet Logic

The app combines all models and:
1. Calculates average probability from all models
2. Compares to implied probability from user odds
3. Identifies "value bets" where model probability > implied probability
4. Recommends bet with highest value

**Value Formula:**
```
Value = (Model Probability / Implied Probability) - 1
```

## Data Freshness

- **Recommended:** Update every 7-14 days during season
- **Warning:** Triggered after 30 days without update
- **Critical:** Data older than 60 days should not be used

The app will warn users when data is stale.

## Security Considerations

### For Production:
1. **Change admin password** in `/admin/index.php`
2. **Use HTTPS** (SSL certificate)
3. **Implement proper authentication** (not just password)
4. **Restrict admin access** via `.htaccess`
5. **Set proper file permissions** (644 for files, 755 for directories)
6. **Keep PHP updated**
7. **Use prepared statements** (already implemented)
8. **Sanitize all inputs** (already implemented)

### .htaccess for Admin Protection

Create `/admin/.htaccess`:
```apache
<Files "index.php">
    AuthType Basic
    AuthName "Admin Area"
    AuthUserFile /home/yourusername/.htpasswd
    Require valid-user
</Files>
```

## Troubleshooting

### Database Connection Error
- Check credentials in `/includes/config.php`
- Verify database exists
- Check MySQL is running

### CSV Import Fails
- Verify CSV format matches template
- Check file encoding (UTF-8)
- Review error log in admin panel

### Teams Not Appearing
- Ensure CSV has been imported
- Check league selection
- Verify database has data

### Analytics Not Tracking
- Verify GA_TRACKING_ID in config
- Check Google Analytics account
- Allow 24 hours for data to appear

## Updating Data

### Regular Updates

1. Go to Admin Panel
2. Click "CSV Import" tab
3. Select league and season
4. Upload new CSV file
5. Monitor progress

### Bulk Updates

1. Prepare multiple CSV files
2. Upload one at a time
3. System automatically aggregates statistics

## Monetization

### Ad Integration

#### Custom Ads
- Add your own HTML/JavaScript
- Control duration and URL
- Appears at top of page

#### Network Ads
- Integrate PropellerAds, Adsterra, etc.
- Appears in middle of page
- CPM or CPC payment model

### Recommended Ad Networks
- **PropellerAds:** https://propellerads.com
- **Adsterra:** https://adsterra.com
- **Clickadu:** https://clickadu.com
- **Popcash:** https://popcash.net

## Support & Maintenance

### Regular Maintenance
- Update data weekly during season
- Monitor error logs
- Check Google Analytics
- Review user feedback

### Backup
- Backup database regularly
- Backup uploaded CSV files
- Keep version control

## API Endpoints

### Get Teams by League
```
GET /public/api/get-teams.php?league_id=1
Response: {
    "success": true,
    "teams": [
        {"id": 1, "name": "Arsenal"},
        {"id": 2, "name": "Chelsea"}
    ]
}
```

### Get Prediction
```
POST /public/predict.php
Parameters:
- home_team: int
- away_team: int
- league: int
- odds_home: float
- odds_draw: float
- odds_away: float
- csrf_token: string

Response: {
    "success": true,
    "match": {...},
    "recommendation": {...},
    "models": {...}
}
```

## File Structure

```
odds-predictor/
├── public/
│   ├── index.php           # Main application
│   ├── age-verification.php # Age check popup
│   ├── predict.php         # Prediction API
│   ├── api/
│   │   └── get-teams.php   # Teams API
│   └── ...
├── admin/
│   ├── index.php           # Admin login
│   ├── dashboard.php       # Admin panel
│   └── ...
├── includes/
│   ├── config.php          # Configuration
│   ├── database.sql        # Database schema
│   ├── PredictionEngine.php # Prediction models
│   ├── CSVImporter.php     # CSV import handler
│   └── ...
├── css/
│   └── style.css           # Styling
├── js/
│   └── app.js              # JavaScript
├── data/
│   └── CSV_TEMPLATE.md     # CSV template
├── logs/                   # Log files
├── uploads/                # Uploaded files
└── README.md               # This file
```

## License & Disclaimer

This software is provided "as is" for entertainment purposes only. Users must be 18+ and understand gambling risks.

**Important:** This tool is NOT financial advice. We assume NO liability for losses incurred through its use. Always gamble responsibly.

## Support

For issues or questions:
1. Check troubleshooting section
2. Review error logs
3. Contact hosting provider for server issues
4. Check database configuration

## Version

**Version:** 1.0.0
**Last Updated:** December 2024

---

**Remember:** Gamble responsibly. If you have a gambling problem, seek help at GambleAware.co.uk or NCPG.org.uk
