<?php
require_once __DIR__ . '/../includes/config.php';

// Simple admin authentication (in production, use proper authentication)
$admin_password = 'admin123'; // CHANGE THIS!

session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $password = isset($_POST['password']) ? $_POST['password'] : '';
    
    if ($password === $admin_password) {
        $_SESSION['admin_authenticated'] = true;
        header('Location: /odds-predictor/admin/dashboard.php');
        exit;
    } else {
        $error = 'Invalid password';
    }
}

if (isset($_SESSION['admin_authenticated']) && $_SESSION['admin_authenticated']) {
    header('Location: /odds-predictor/admin/dashboard.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - <?php echo APP_NAME; ?></title>
    <link rel="stylesheet" href="/odds-predictor/css/style.css">
    <style>
        .admin-login {
            max-width: 400px;
            margin: 100px auto;
            background: white;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.2);
        }
        
        .admin-login h1 {
            color: var(--primary-color);
            text-align: center;
            margin-bottom: 30px;
        }
        
        .admin-login .form-group {
            margin-bottom: 20px;
        }
        
        .admin-login input {
            width: 100%;
            padding: 12px;
            border: 1px solid var(--border-color);
            border-radius: 5px;
            font-size: 16px;
        }
        
        .admin-login button {
            width: 100%;
            padding: 12px;
            background: var(--primary-color);
            color: white;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
        }
        
        .admin-login button:hover {
            background: #1565c0;
        }
        
        .error {
            background: #ffebee;
            color: #c62828;
            padding: 12px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="admin-login">
        <h1>Admin Panel</h1>
        
        <?php if (isset($error)): ?>
        <div class="error"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>
        
        <form method="POST">
            <div class="form-group">
                <label for="password">Admin Password:</label>
                <input type="password" id="password" name="password" required autofocus>
            </div>
            
            <button type="submit">Login</button>
        </form>
    </div>
</body>
</html>
