# Odds Predictor - CSV Data Template

## Overview
This template is used to populate the Odds Predictor database with historical football match data. You can reuse this template each time you need to update the database with new data.

## File Format
- **Format:** CSV (Comma-Separated Values)
- **Encoding:** UTF-8
- **Line Endings:** LF (Unix style)
- **Delimiter:** Comma (,)

## Column Headers (Required)
The CSV file MUST include these columns in this exact order:

```
Date,HomeTeam,AwayTeam,FTHG,FTAG,FTR,HS,AS,HST,AST,HF,AF,HC,AC,B365H,B365D,B365A
```

## Column Descriptions

| Column | Description | Format | Example | Required |
|--------|-------------|--------|---------|----------|
| Date | Match date | DD/MM/YYYY or YYYY-MM-DD | 26/12/2024 | Yes |
| HomeTeam | Home team name | Text | Arsenal | Yes |
| AwayTeam | Away team name | Text | Chelsea | Yes |
| FTHG | Full-time home goals | Integer | 2 | Yes |
| FTAG | Full-time away goals | Integer | 1 | Yes |
| FTR | Full-time result | H/D/A | H | Yes |
| HS | Home shots | Integer | 15 | No |
| AS | Away shots | Integer | 8 | No |
| HST | Home shots on target | Integer | 6 | No |
| AST | Away shots on target | Integer | 3 | No |
| HF | Home fouls | Integer | 12 | No |
| AF | Away fouls | Integer | 14 | No |
| HC | Home corners | Integer | 5 | No |
| AC | Away corners | Integer | 2 | No |
| B365H | Bet365 home odds | Decimal | 1.92 | No |
| B365D | Bet365 draw odds | Decimal | 3.30 | No |
| B365A | Bet365 away odds | Decimal | 4.60 | No |

## Field Details

### Date
- Accepted formats: DD/MM/YYYY, YYYY-MM-DD, DD-MM-YYYY, MM/DD/YYYY
- Example: 26/12/2024 or 2024-12-26

### Result (FTR)
- **H** = Home Win
- **D** = Draw
- **A** = Away Win

### Odds
- Decimal format (European odds)
- Example: 1.92, 3.30, 4.60
- If not available, leave blank

## Example CSV Data

```csv
Date,HomeTeam,AwayTeam,FTHG,FTAG,FTR,HS,AS,HST,AST,HF,AF,HC,AC,B365H,B365D,B365A
26/12/2024,Arsenal,Chelsea,2,1,H,15,8,6,3,12,14,5,2,1.92,3.30,4.60
26/12/2024,Manchester United,Liverpool,1,1,D,12,11,4,4,10,12,3,3,2.10,3.20,3.50
27/12/2024,Tottenham,Manchester City,0,3,A,8,18,2,8,15,10,2,6,4.50,3.40,1.87
```

## How to Use This Template

### Step 1: Prepare Your Data
1. Gather match data from reliable sources (football-data.co.uk, ESPN, official league websites)
2. Organize data in the format specified above
3. Ensure all required fields are populated

### Step 2: Create CSV File
1. Open Excel, Google Sheets, or any text editor
2. Create columns with the headers listed above
3. Enter your match data row by row
4. Save as CSV format (File → Save As → Format: CSV)

### Step 3: Upload to Admin Panel
1. Go to: `http://yoursite.com/admin/import.php`
2. Select the CSV file
3. Choose the league and season
4. Click "Import"
5. Review the import results

### Step 4: Send to Developer
If you need assistance updating data:
1. Prepare CSV file following this template
2. Include the season (e.g., 2024/25)
3. Specify the league
4. Send to developer for processing

## Data Validation Rules

- **Date:** Must be a valid date
- **Team Names:** Must match existing teams or will be created
- **Goals:** Must be non-negative integers
- **Result:** Must be H, D, or A
- **Odds:** Must be positive decimals (typically 1.0 - 50.0)
- **Statistics:** Must be non-negative integers

## Common Issues & Solutions

### Issue: "Invalid date format"
**Solution:** Ensure dates are in DD/MM/YYYY or YYYY-MM-DD format

### Issue: "Team not found"
**Solution:** Team will be automatically created if it doesn't exist

### Issue: "Duplicate match"
**Solution:** System will update existing match data if date, teams match

### Issue: "Invalid odds format"
**Solution:** Use decimal format (1.92, not 1-92 or 1.92/1)

## Data Sources

Recommended sources for accurate data:

1. **football-data.co.uk** - Free historical data with odds
2. **ESPN** - Match results and statistics
3. **Transfermarkt** - Comprehensive football database
4. **Official League Websites** - Most accurate official data
5. **FBref** - Advanced statistics including xG

## Recommended Update Frequency

- **Weekly:** For active seasons (during matches)
- **Monthly:** For off-season maintenance
- **After Major Events:** AFCON, World Cup, etc.

## Data Range Recommendations

For optimal predictions, maintain data from:
- **Minimum:** Current season + 2 previous seasons
- **Optimal:** 2022/23 to 2024/25 (3 seasons)
- **Maximum:** 5 seasons (older data becomes less relevant)

The system will warn you when data is older than 30 days.

## Support

For issues or questions about data import:
1. Check the error log in the admin panel
2. Verify CSV format matches template exactly
3. Ensure all required fields are populated
4. Contact support with sample CSV file

---

**Last Updated:** December 2024
**Version:** 1.0
