<?php
/**
 * Odds Prediction App - Configuration File
 * Database and Application Settings
 */

// Database Configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_NAME', 'odds_predictor');

// Application Settings
define('APP_NAME', 'Odds Predictor');
define('APP_VERSION', '1.0.0');
define('APP_URL', 'http://localhost/odds-predictor');
define('ADMIN_URL', 'http://localhost/odds-predictor/admin');

// Google Analytics
define('GA_TRACKING_ID', 'G-XXXXXXXXXX'); // Replace with your GA ID

// Ad Configuration
define('CUSTOM_AD_ENABLED', true);
define('NETWORK_AD_ENABLED', true);

// Data Configuration
define('MIN_SEASON', '2022/23');
define('MAX_SEASON', '2024/25');
define('DATA_FRESHNESS_WARNING_DAYS', 30);

// Prediction Models
define('PREDICTION_MODELS', [
    'poisson' => 'Poisson Distribution',
    'win_percentage' => 'Win Percentage Analysis',
    'xg' => 'Expected Goals (xG)',
    'form' => 'Recent Form Analysis'
]);

// Session Configuration
session_start();
ini_set('session.cookie_httponly', 1);
ini_set('session.cookie_secure', 0); // Set to 1 in production with HTTPS
ini_set('session.cookie_samesite', 'Lax');

// Error Reporting
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/../logs/error.log');

// Create logs directory if it doesn't exist
if (!is_dir(__DIR__ . '/../logs')) {
    mkdir(__DIR__ . '/../logs', 0755, true);
}

// Database Connection Function
function getDBConnection() {
    try {
        $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
        
        if ($conn->connect_error) {
            throw new Exception("Connection failed: " . $conn->connect_error);
        }
        
        $conn->set_charset("utf8mb4");
        return $conn;
    } catch (Exception $e) {
        error_log("Database connection error: " . $e->getMessage());
        die("Database connection failed. Please try again later.");
    }
}

// Helper Functions
function sanitizeInput($data) {
    return htmlspecialchars(strip_tags(trim($data)), ENT_QUOTES, 'UTF-8');
}

function validateEmail($email) {
    return filter_var($email, FILTER_VALIDATE_EMAIL);
}

function generateSessionId() {
    return bin2hex(random_bytes(16));
}

function logActivity($action, $details = '') {
    $log_file = __DIR__ . '/../logs/activity.log';
    $timestamp = date('Y-m-d H:i:s');
    $session_id = isset($_SESSION['id']) ? $_SESSION['id'] : 'unknown';
    $log_entry = "[$timestamp] Session: $session_id | Action: $action | Details: $details\n";
    file_put_contents($log_file, $log_entry, FILE_APPEND);
}

// CSRF Token Generation
function generateCSRFToken() {
    if (empty($_SESSION['csrf_token'])) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    }
    return $_SESSION['csrf_token'];
}

function validateCSRFToken($token) {
    return isset($_SESSION['csrf_token']) && hash_equals($_SESSION['csrf_token'], $token);
}

// Age Verification
function isAgeVerified() {
    return isset($_SESSION['age_verified']) && $_SESSION['age_verified'] === true;
}

function setAgeVerified() {
    $_SESSION['age_verified'] = true;
    $_SESSION['age_verified_time'] = time();
}
?>
