<?php
require_once __DIR__ . '/../includes/config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $age = isset($_POST['age']) ? (int)$_POST['age'] : 0;
    $agree = isset($_POST['agree']) ? true : false;
    
    if ($age >= 18 && $agree) {
        setAgeVerified();
        header('Location: /odds-predictor/public/index.php');
        exit;
    } else {
        $error = 'You must be 18 years or older to continue.';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Age Verification - <?php echo APP_NAME; ?></title>
    <link rel="stylesheet" href="/odds-predictor/css/style.css">
    <style>
        .age-verification-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.8);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 9999;
        }
        
        .age-verification-modal {
            background: white;
            padding: 40px;
            border-radius: 10px;
            max-width: 500px;
            text-align: center;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.3);
        }
        
        .age-verification-modal h1 {
            color: #d32f2f;
            margin-bottom: 20px;
            font-size: 28px;
        }
        
        .age-verification-modal p {
            margin: 15px 0;
            line-height: 1.6;
            color: #333;
        }
        
        .age-form {
            margin: 30px 0;
        }
        
        .age-form input[type="number"] {
            width: 100%;
            padding: 12px;
            margin: 10px 0;
            border: 2px solid #ddd;
            border-radius: 5px;
            font-size: 16px;
        }
        
        .age-form label {
            display: flex;
            align-items: center;
            margin: 15px 0;
            font-size: 14px;
        }
        
        .age-form input[type="checkbox"] {
            margin-right: 10px;
            width: 18px;
            height: 18px;
            cursor: pointer;
        }
        
        .age-form button {
            width: 100%;
            padding: 12px;
            background: #d32f2f;
            color: white;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            margin-top: 20px;
        }
        
        .age-form button:hover {
            background: #b71c1c;
        }
        
        .error {
            color: #d32f2f;
            background: #ffebee;
            padding: 10px;
            border-radius: 5px;
            margin: 15px 0;
        }
        
        .warning {
            background: #fff3e0;
            padding: 15px;
            border-left: 4px solid #ff9800;
            margin: 20px 0;
            text-align: left;
        }
    </style>
</head>
<body>
    <div class="age-verification-overlay">
        <div class="age-verification-modal">
            <h1>⚠️ Age Verification Required</h1>
            
            <p>
                This website contains content related to gambling and betting odds predictions. 
                By law, you must be of legal age to access this content.
            </p>
            
            <div class="warning">
                <strong>Important:</strong> This tool is for entertainment purposes only. 
                It is not financial advice. Gambling involves risk and may not be suitable for everyone.
            </div>
            
            <form method="POST" class="age-form">
                <label for="age">How old are you?</label>
                <input type="number" id="age" name="age" min="1" max="120" placeholder="Enter your age" required>
                
                <label>
                    <input type="checkbox" name="agree" required>
                    I confirm I am 18 years or older and understand the risks of gambling
                </label>
                
                <?php if (isset($error)): ?>
                <div class="error"><?php echo htmlspecialchars($error); ?></div>
                <?php endif; ?>
                
                <button type="submit">I Confirm - Continue</button>
            </form>
            
            <p style="font-size: 12px; color: #999; margin-top: 20px;">
                If you have a gambling problem, please seek help:<br>
                <a href="https://www.gambleaware.co.uk" target="_blank">GambleAware.co.uk</a> | 
                <a href="https://www.ncpg.org.uk" target="_blank">NCPG</a>
            </p>
        </div>
    </div>
</body>
</html>
