<?php
require_once __DIR__ . '/../../includes/config.php';

header('Content-Type: application/json');

$league_id = isset($_GET['league_id']) ? (int)$_GET['league_id'] : 0;

if (!$league_id) {
    echo json_encode(['success' => false, 'error' => 'League ID required']);
    exit;
}

try {
    $conn = getDBConnection();
    
    $query = "SELECT id, name FROM teams WHERE league_id = ? ORDER BY name";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $league_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $teams = [];
    while ($row = $result->fetch_assoc()) {
        $teams[] = $row;
    }
    
    echo json_encode(['success' => true, 'teams' => $teams]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>
