<?php
require_once __DIR__ . '/../includes/config.php';

// Check age verification
if (!isAgeVerified()) {
    include __DIR__ . '/age-verification.php';
    exit;
}

// Get database connection
$conn = getDBConnection();

// Get available leagues
$leagues_query = "SELECT * FROM leagues ORDER BY country, name";
$leagues_result = $conn->query($leagues_query);
$leagues = [];
while ($row = $leagues_result->fetch_assoc()) {
    $leagues[] = $row;
}

// Get data freshness warning
$config_query = "SELECT * FROM data_config WHERE config_key IN ('last_data_update', 'data_freshness_warning_days')";
$config_result = $conn->query($config_query);
$config = [];
while ($row = $config_result->fetch_assoc()) {
    $config[$row['config_key']] = $row['config_value'];
}

$last_update = strtotime($config['last_data_update'] ?? date('Y-m-d'));
$days_since_update = floor((time() - $last_update) / 86400);
$warning_days = $config['data_freshness_warning_days'] ?? 30;
$show_data_warning = $days_since_update > $warning_days;

// Get ad configuration
$ads_query = "SELECT * FROM ad_config WHERE enabled = 1";
$ads_result = $conn->query($ads_query);
$ads = [];
while ($row = $ads_result->fetch_assoc()) {
    $ads[$row['ad_type']][$row['position']] = $row;
}

$csrf_token = generateCSRFToken();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo APP_NAME; ?> - Odds Prediction Tool</title>
    <link rel="stylesheet" href="/odds-predictor/css/style.css">
    <!-- Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo GA_TRACKING_ID; ?>"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());
        gtag('config', '<?php echo GA_TRACKING_ID; ?>');
    </script>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <header class="header">
            <div class="logo">
                <h1><?php echo APP_NAME; ?></h1>
                <p>Advanced Odds Prediction Tool</p>
            </div>
            <nav class="nav">
                <a href="/odds-predictor/public/index.php">Predictor</a>
                <a href="#legal">Legal</a>
                <a href="/odds-predictor/admin/">Admin</a>
            </nav>
        </header>

        <!-- Data Freshness Warning -->
        <?php if ($show_data_warning): ?>
        <div class="alert alert-warning">
            <strong>⚠️ Data Freshness Warning:</strong> The database was last updated <?php echo $days_since_update; ?> days ago. 
            For accurate predictions, data should be updated at least every <?php echo $warning_days; ?> days.
            <a href="/odds-predictor/admin/">Update data</a>
        </div>
        <?php endif; ?>

        <!-- Ad Slot: Top -->
        <?php if (isset($ads['custom']['top'])): ?>
        <div class="ad-slot ad-slot-top">
            <?php echo $ads['custom']['top']['ad_code']; ?>
        </div>
        <?php endif; ?>

        <!-- Main Content -->
        <main class="main-content">
            <!-- Legal Disclaimer -->
            <div class="legal-disclaimer">
                <h3>⚖️ Important Legal Disclaimer</h3>
                <p>
                    <strong>Entertainment Purposes Only:</strong> This tool is provided for entertainment and educational purposes only. 
                    It is NOT financial advice and should not be used as the sole basis for making betting decisions.
                </p>
                <p>
                    <strong>No Liability:</strong> We assume no liability for any losses incurred through the use of this tool. 
                    Betting and gambling involve risk and are not suitable for everyone.
                </p>
                <p>
                    <strong>Not Financial Advisors:</strong> We are not licensed financial advisors. Always consult with a professional 
                    before making financial decisions.
                </p>
                <p>
                    <strong>Age Restriction:</strong> Users must be of legal gambling age in their jurisdiction (typically 18+).
                </p>
                <p>
                    <strong>Responsible Gambling:</strong> If you or someone you know has a gambling problem, please seek help. 
                    Visit <a href="https://www.gambleaware.co.uk" target="_blank">GambleAware</a> or 
                    <a href="https://www.ncpg.org.uk" target="_blank">National Council on Problem Gambling</a>.
                </p>
            </div>

            <!-- Prediction Form -->
            <form id="predictionForm" class="prediction-form" method="POST" action="predict.php">
                <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">

                <div class="form-section">
                    <h2>Select Teams & League</h2>
                    
                    <div class="form-group">
                        <label for="league">League:</label>
                        <select id="league" name="league" required onchange="loadTeams()">
                            <option value="">-- Select League --</option>
                            <?php foreach ($leagues as $league): ?>
                            <option value="<?php echo $league['id']; ?>">
                                <?php echo htmlspecialchars($league['name']); ?> (<?php echo htmlspecialchars($league['country']); ?>)
                            </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label for="home_team">Home Team:</label>
                            <select id="home_team" name="home_team" required>
                                <option value="">-- Select Team --</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="away_team">Away Team:</label>
                            <select id="away_team" name="away_team" required>
                                <option value="">-- Select Team --</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="form-section">
                    <h2>Enter Current Odds</h2>
                    <p class="form-hint">Enter the odds you're seeing in your betting app</p>

                    <div class="form-row">
                        <div class="form-group">
                            <label for="odds_home">Home Win Odds:</label>
                            <input type="number" id="odds_home" name="odds_home" step="0.01" min="1.0" placeholder="e.g., 1.92" required>
                        </div>

                        <div class="form-group">
                            <label for="odds_draw">Draw Odds:</label>
                            <input type="number" id="odds_draw" name="odds_draw" step="0.01" min="1.0" placeholder="e.g., 3.30" required>
                        </div>

                        <div class="form-group">
                            <label for="odds_away">Away Win Odds:</label>
                            <input type="number" id="odds_away" name="odds_away" step="0.01" min="1.0" placeholder="e.g., 4.60" required>
                        </div>
                    </div>
                </div>

                <button type="submit" class="btn btn-primary">Get Prediction</button>
            </form>

            <!-- Ad Slot: Middle -->
            <?php if (isset($ads['network']['middle'])): ?>
            <div class="ad-slot ad-slot-middle">
                <?php echo $ads['network']['middle']['ad_code']; ?>
            </div>
            <?php endif; ?>
        </main>

        <!-- Results Container (populated via AJAX) -->
        <div id="results" class="results-container"></div>

        <!-- Ad Slot: Bottom -->
        <?php if (isset($ads['custom']['bottom'])): ?>
        <div class="ad-slot ad-slot-bottom">
            <?php echo $ads['custom']['bottom']['ad_code']; ?>
        </div>
        <?php endif; ?>

        <!-- Footer -->
        <footer class="footer" id="legal">
            <div class="footer-content">
                <h3>Legal Information</h3>
                <p>
                    <strong>Disclaimer:</strong> This tool is for entertainment purposes only. We make no guarantees about prediction accuracy. 
                    Gambling involves risk and may not be suitable for everyone. Always gamble responsibly.
                </p>
                <p>
                    <strong>Privacy:</strong> We collect minimal data and use Google Analytics for site improvement. 
                    Your betting data is not shared with third parties.
                </p>
                <p>
                    <strong>Terms:</strong> By using this tool, you agree that you are of legal age and understand the risks of gambling.
                </p>
                <p>
                    <strong>Contact:</strong> For issues or questions, please contact support.
                </p>
                <p style="margin-top: 20px; font-size: 0.9em; color: #666;">
                    © <?php echo date('Y'); ?> <?php echo APP_NAME; ?>. All rights reserved.
                </p>
            </div>
        </footer>
    </div>

    <script src="/odds-predictor/js/app.js"></script>
</body>
</html>
